// Extensão dos Arquivos
const pageExtention = '.html';
const chatbootContainItem = document.querySelectorAll('.chatboot-contain-item');
var tipoDispositivo = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ? 'telefone' : 'computador';

// document.addEventListener('DOMContentLoaded', function () {
//   backSlider.style.display = 'none';
//   chatboLabel.style.paddingLeft = '10px';

//   toggleAnexo.addEventListener('click', function (e) {
//     e.preventDefault();
//     this.classList.toggle('gear');
//     this.previousElementSibling.classList.toggle('open');
//   });


//   fecharChatboot.addEventListener('click', function (e) {
//     e.preventDefault();
//     chatboot.classList.remove('show');
//   });

//   abrirChaboot.addEventListener('click', function (e) {
//     this.nextElementSibling.classList.add('show');
//   });

//   // Carrega Todas as Paginas 
//   carregarPagina(MoneySection, 'unitelMoney');

//   carregarPagina(chatSection, 'chat');

//   carregarPagina(NetSection, 'net');

//   carregarPagina(PaySection, 'pay');
//   carregarPagina(planosDetailsSection, 'details');

//   carregarPagina(PlanosSection, 'planoMais', (done) => {
//     callBAZZA.addEventListener('click', function (e) {
//       e.preventDefault();
//       tornarVisivel(planosDetailsSection);
//       backSlider.style.display = 'flex';
//       chatboLabel.style.paddingLeft = '0px';
//       voltarSlider(welcomeSection, true);
//     });
//   });

//   carregarPagina(welcomeSection, 'welcome', function (done) {
//     const links = document.querySelectorAll('.toolbar-link');
//     links.forEach(link => {
//       link.addEventListener('click', function (e) {
//         e.preventDefault();
//         chamarCadaMenu(this.id.split('-')[1]);
//         backSlider.style.display = 'flex';
//         chatboLabel.style.paddingLeft = '0px';
//         voltarSlider(welcomeSection, true);
//       });
//     });
//     manageLinks();
//     clearChat.addEventListener('click', function () {
//       if (chating) {
//         const nodes = chating.querySelectorAll('li');
//         if (nodes.length > 0) {
//           nodes.forEach(node => {
//             chating.removeChild(node);
//           });
//         }
//         chating.innerHTML = '';
//       }
//     });

//   });
//   // Adiciona um evento ao Submeter o Formulario

//   formMaibox.addEventListener('submit', function (e) {
//     e.preventDefault();
//     backSlider.style.display = 'flex';
//     voltarSlider(welcomeSection, true);

//     var input = this.querySelector('#chatInput');
//     chamarTelaChat(input.value);
//     input.value = '';
//   });


//   // Tornar a primeira tela Visivel
//   tornarVisivel(welcomeSection);

// });

document.addEventListener('DOMContentLoaded', function () {
  backSlider.style.display = 'none';
  chatboLabel.style.paddingLeft = '10px';

  toggleAnexo.addEventListener('click', function (e) {
    e.preventDefault();
    this.classList.toggle('gear');
    this.previousElementSibling.classList.toggle('open');
  });

  fecharChatboot.addEventListener('click', function (e) {
    e.preventDefault();
    chatboot.classList.remove('show');
  });

  abrirChaboot.addEventListener('click', function (e) {
    this.nextElementSibling.classList.add('show');
  });

  // Carrega Todas as Paginas
  const pagesToLoad = [
    carregarPagina(MoneySection, 'unitelMoney'),
    carregarPagina(chatSection, 'chat'),
    carregarPagina(NetSection, 'net'),
    carregarPagina(PaySection, 'pay'),
    carregarPagina(planosDetailsSection, 'details'),
    carregarPagina(PlanosSection, 'planoMais'),
    carregarPagina(welcomeSection, 'welcome')
  ];

  Promise.all(pagesToLoad).then(() => {
    // Código que deve ser executado após o carregamento de todas as páginas
    const links = document.querySelectorAll('.toolbar-link');
    links.forEach(link => {
      link.addEventListener('click', function (e) {
        e.preventDefault();
        chamarCadaMenu(this.id.split('-')[1]);
        backSlider.style.display = 'flex';
        chatboLabel.style.paddingLeft = '0px';
        voltarSlider(welcomeSection, true);
      });
    });

    manageLinks();

    clearChat.addEventListener('click', function () {
      if (chating) {
        const nodes = chating.querySelectorAll('li');
        if (nodes.length > 0) {
          nodes.forEach(node => {
            chating.removeChild(node);
          });
        }
        chating.innerHTML = '';
      }
    });

    // Tornar a primeira tela Visivel
    tornarVisivel(welcomeSection);
  }).catch(err => {
    console.error('Erro ao carregar algumas páginas:', err);
  });
});


function manageLinks() {
  const callChatBtns = document.querySelectorAll('.call-chat');
  callChatBtns.forEach((btn, i) => {
    btn.addEventListener('click', function (e) {
      e.preventDefault();
      return chamarTelaChat(this.innerText);
    });
  });
}

// Comecar o Chat

function chamarTelaChat(text, comingIn = null) {
  tornarVisivel(chatSection);
  var elem = `
      <div class="outgoing">
        <span>${text}</span>
      </div>
      <div class="wait-incoming">
        <span class="dot"></span>
        <span class="dot"></span>
        <span class="dot"></span>
      </div>
  `;
  chating.innerHTML += elem;
  scrollToBottom();
  gerarRespostas__(chating, text);
}



const gerarRespostas__ = (box, insertedText) => {

  // const API_URL = "https://ai.mayongi-ao.com/roboapi/public/api/gerarRespostas";
  const API_URL = "http://127.0.0.1:8000/api/gerarRespostas";
  // const api_resposta = Resposta.querySelector("p");

  const requestOptions = {
    method: "POST",
    headers: {
      "Content-Type": "Application/json",
      // Adicione quaisquer cabeçalhos de autenticação necessários aqui
    },
    body: JSON.stringify({
      mensagem: insertedText, // Certifique-se de que a sua API Laravel espera o corpo nesta estrutura
      tipoDispositivo: tipoDispositivo
    })
  };

  fetch(API_URL, requestOptions)
    .then(res => res.json())
    .then(data => {

      if (box) {
        console.log(data);

        var resposta = data.resposta;
        var incoming__ = `
          <li class="incoming">
            <span> ${resposta}</span>
          </li >
          `;

        const pontosDeEspera = document.querySelectorAll('.wait-incoming');
        pontosDeEspera.forEach(pontos => pontos.classList.add('hide'));

        console.log(box);
        box.innerHTML += incoming__;

        console.log(box);

        pageContain.scrollTop = pageContain.scrollHeight;

      } else {
        console.log('not found');
      }

      scrollToBottom();

    })
    .catch((error) => {
      // let incoming = `
      //   <li class="incoming">
      //     <span> ${"Tenta mais Tarde" + tipoDispositivo}</span>
      //   </li >
      // `;

      // var containerChat = document.querySelector('.sectionChat');
      // const pontosDeEspera = document.querySelectorAll('.wait-incoming');
      // pontosDeEspera.forEach(pontos => pontos.classList.add('hide'));
      // if (containerChat)
      //   containerChat.innerHTML += incoming;

      // api_resposta.textContent = "Tenta mais Tarde" + tipoDispositivo;
      console.log("errr");
    });
}


function voltarSlider(target, isFirst = null) {
  backSlider.addEventListener('click', function (e) {
    e.preventDefault();
    tornarVisivel(target);
    if (isFirst != null) {
      backSlider.style.display = 'none';
      chatboLabel.style.paddingLeft = '0px';
    }
  });
}


//

function chamarCadaMenu(target) {
  switch (target) {
    case "1":
      tornarVisivel(MoneySection);
      break;
    case "2":
      tornarVisivel(PlanosSection);
      break;
    case "3":
      tornarVisivel(NetSection);
      break;
    case "4":
      tornarVisivel(PaySection);
      break;
  }
}


// Tornar visivel uma pagina

function tornarVisivel(page) {
  chatbootContainItem.forEach(item => item.classList.remove('active'));
  page.classList.add('active');

}

// Carregar Pagina

function carregarPagina1(container, pageSection, done = null) {
  $.ajax({
    url: `./pages/${pageSection}${pageExtention}`,
    // dataType: 'text/html', // Corrigido aqui
    contentType: false,
    processData: false,
    // async: false,
    success: function (response) {
      container.innerHTML = response
      if (done) {
        done(response);
      }
    },
    error: function (err) {
      console.log('Erro ao carregar a página:', err);
    }
  });
}

function carregarPagina(container, pageSection) {
  return new Promise((resolve, reject) => {
    $.ajax({
      url: `./pages/${pageSection}${pageExtention}`,
      // dataType: 'text/html',
      contentType: false,
      processData: false,
      success: function (response) {
        container.innerHTML = response;
        resolve(); // Resolve a Promise quando o carregamento é bem-sucedido
      },
      error: function (err) {
        console.log('Erro ao carregar a página:', err);
        reject(err); // Rejeita a Promise em caso de erro
      }
    });
  });
}



function scrollToBottom() {
  var pageContain = document.getElementById('pageContain');
  pageContain.scrollTop = pageContain.scrollHeight;
}
